<?php
session_start();
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

if (!isset($_SESSION['status_Account']) || $_SESSION['status_Account'] !== 'logged_in') {
    header("Location: ../index.php");
    exit;
}

include '../database/db.php';

$email = $_SESSION['email'];
$stmt = $connection->prepare("SELECT * FROM data WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if ($user['user_status'] != 1) {
    header("Location: ../dashboard/dashboard.php");
    exit;
}

// Fetch appointments
$limit = 10; // rows per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Add search parameter
$search = isset($_GET['search']) ? $_GET['search'] : '';
$searchCondition = '';
$searchParams = [];

if ($search) {
    $searchCondition = "WHERE CONCAT(first_name, ' ', last_name) LIKE ?";
    $searchParams[] = "%$search%";
}

// Count total rows with search
$totalQuery = "SELECT COUNT(*) AS total FROM appointments $searchCondition";
$stmt = $connection->prepare($totalQuery);
if (!empty($searchParams)) {
    $stmt->bind_param(str_repeat('s', count($searchParams)), ...$searchParams);
}
$stmt->execute();
$totalResult = $stmt->get_result();
$totalRow = $totalResult->fetch_assoc();
$totalAppointments = $totalRow['total'];
$totalPages = ceil($totalAppointments / $limit);

// Fetch appointments with search and pagination
$appointmentQuery = "SELECT * FROM appointments $searchCondition ORDER BY created_at DESC LIMIT ? OFFSET ?";
$stmt = $connection->prepare($appointmentQuery);
if (!empty($searchParams)) {
    $stmt->bind_param(str_repeat('s', count($searchParams)) . 'ii', ...[...$searchParams, $limit, $offset]);
} else {
    $stmt->bind_param('ii', $limit, $offset);
}
$stmt->execute();
$appointments = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Dashboard - Appointments</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    <link rel="icon" type="image/x-icon" href="../image/icons/logo1.ico">
    <link rel="stylesheet" href="../css/style.css">
    <link rel="stylesheet" href="../css/admin_dashboard1.css">
</head>
<body>

<!-- Sidebar -->
<div class="sidebar">
    <img src="../image/icons/logo1.ico" alt="Organization Logo" class="logo">
    <button class="close-sidebar" aria-label="Close Sidebar">
        <i class='bx bx-x'></i>
    </button>
    <h2>Admin Dashboard</h2>
    <a href="./admin_dashboard.php" class="active">Home</a>
    <a href="./record.php">Record</a>
    <a href="./notifications.php">Notifications <span id="notification-count" style="display:none;" class="badge"></span></a>
    <a href="../logout.php">Logout</a>
</div>

<!-- Main Content -->
<div class="main-content">
    <div class="dashboard-header">
        <button class="menu-toggle" aria-label="Toggle Sidebar" aria-expanded="false">
            <i class='bx bx-menu'></i>
        </button>
        <h1>Appointment Requests</h1>
        <?php if (isset($_SESSION['notification'])): ?>
            <p style="color: green;">
                <?= htmlspecialchars($_SESSION['notification']); unset($_SESSION['notification']); ?>
            </p>
        <?php endif; ?>
    </div>
    
    <div class="controls-wrapper">
        <div class="search-container">
            <input type="text" id="searchInput" placeholder="Search by client's name...">
            <button type="button" id="searchButton" class="search-btn">
                <i class='bx bx-search'></i>
            </button>
            <button type="button" id="clearSearch" class="clear-btn" style="display: none;">
                <i class='bx bx-x'></i>
            </button>
        </div>
        
        <div class="download-report">
            <button id="downloadReportBtn" class="download-btn">
                <i class='bx bxs-download'></i>
                Generate Report
            </button>
        </div>
    </div>

    <!-- Download report modal -->
    <div id="reportModal" class="modal">
        <div class="modal-content">
            <span class="close-btn" id="reportModalClose">&times;</span>
            <h2>Generate Monthly Report</h2>
            <form id="reportForm" method="POST" action="generate_report.php">
                <div class="form-group">
                    <label for="reportMonth">Month:</label>
                    <input type="month" id="reportMonth" name="reportMonth" required>
                </div>
                <div class="form-group">
                    <label for="reportType">Status Filter:</label>
                    <select id="reportType" name="reportType" required>
                        <option value="all">All Requests</option>
                        <option value="Approved">Approved Only</option>
                        <option value="Rejected">Rejected Only</option>
                        <option value="Pending">Pending Only</option>
                    </select>
                </div>
                <div class="form-group button-group">
                    <button type="submit" name="format" value="pdf" class="generate-btn">Generate PDF</button>
                    <button type="submit" name="format" value="excel" class="generate-btn excel">Generate Excel</button>
                </div>
            </form>
        </div>
    </div>

    <?php if ($appointments->num_rows > 0): ?>
        <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Client Name</th>
                    <th>Email</th>
                    <th>Date</th>
                    <th>Time</th>
                    <th>Status</th>
                    <th>Submitted</th>
                    <th>Action</th>
                    <th>Remarks</th>
                </tr>
            </thead>
           <tbody id="appointment-table-body">
                <?php while ($row = $appointments->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($row['first_name'] . ' ' . $row['last_name']) ?></td>
                        <td><?= htmlspecialchars($row['email']) ?></td>
                        <td><?= htmlspecialchars(date("F j, Y", strtotime($row['appointment_date']))) ?></td>
                        <td><?= htmlspecialchars(date("g:i A", strtotime($row['appointment_time']))) ?></td>
                        <td class="status-cell"><?= htmlspecialchars($row['status']) ?></td>
                        <td><?= htmlspecialchars(date("F j, Y g:i A", strtotime($row['created_at']))) ?></td>
                        <td class="action-cell">
                            <?php if ($row['status'] === 'Pending'): ?>
                                <button class="action-btn view" data-info='<?= json_encode($row) ?>'>View</button>
                                <button class="action-btn accept" data-id="<?= $row['appointment_id'] ?>" data-email="<?= $row['email'] ?>">Accept</button>
                                <button class="action-btn reject" data-id="<?= $row['appointment_id'] ?>" data-email="<?= $row['email'] ?>">Reject</button>
                            <?php else: ?>
                                <button class="action-btn view" data-info='<?= json_encode($row) ?>'>View</button>
                            <?php endif; ?>
                            <button class="action-btn generate" data-info='<?= json_encode($row) ?>'>Generate Form</button>
                        </td>
                        <td>
                            <span 
                                class="remarks-text" 
                                contenteditable="true" 
                                data-id="<?= $row['appointment_id'] ?>"
                                data-placeholder="Click to add remarks…"
                                style="outline:none; min-width:80px; display:inline-block;"
                                title="Click to edit"
                            ><?= !empty($row['remarks']) ? htmlspecialchars($row['remarks']) : '' ?></span>
                        </td>
                    </tr>
                <?php endwhile; ?> 
            </tbody>

        </table>
        </div>
    <?php else: ?>
        <p>No appointments found.</p>
    <?php endif; ?>

    <?php if ($totalPages > 1): ?>
    <div style="margin-top: 20px; text-align: center;">
        <?php 
        for ($i = 1; $i <= $totalPages; $i++): 
            $url = '?page=' . $i;
            if ($search) {
                $url .= '&search=' . urlencode($search);
            }
        ?>
            <a href="<?= $url ?>" style="
                display: inline-block;
                margin: 0 5px;
                padding: 6px 12px;
                background: <?= $i == $page ? '#003087' : '#f0f0f0' ?>;
                color: <?= $i == $page ? '#fff' : '#003087' ?>;
                border: 1px solid #ccc;
                border-radius: 4px;
                text-decoration: none;
                font-weight: <?= $i == $page ? 'bold' : 'normal' ?>;
            ">
                <?= $i ?>
            </a>
        <?php endfor; ?>
    </div>
<?php endif; ?>

</div>

<!--  Popup Box -->
<div id="popup-box" style="display:none; position:fixed; top:20px; right:20px; background:#d4edda; color:#155724; padding:20px; border:1px solid #c3e6cb; border-radius:5px; z-index:9999;">
    <span id="popup-close" style="float:right; cursor:pointer;">&times;</span>
    <p id="popup-message"></p>
</div>

<!-- View Modal -->
<div id="view-modal" class="modal">
    <div class="modal-content">
        <span id="modal-close" class="close-btn">&times;</span>
        <h2 style="text-align: center;">Appointment Details</h2>
        <br>
        <div id="modal-body">
            <!-- Info goes here -->
        </div>
    </div>
</div>

<!--  JavaScript -->
<script src="../scripts/script_admin1.js"></script>
<script src="../scripts/admin_dashboard1.js"></script>
</body>
</html>
