<?php
header('Content-Type: application/json');
include '../database/db.php';

// Ensure POST method
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

// Ensure appointment_id is present
if (!isset($_POST['appointment_id'])) {
    echo json_encode(['success' => false, 'message' => 'No appointment ID provided']);
    exit;
}

$appointment_id = intval($_POST['appointment_id']);

$stmt = $connection->prepare("DELETE FROM appointments WHERE appointment_id = ?");
$stmt->bind_param("i", $appointment_id);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Appointment deleted successfully']);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to delete appointment']);
}

$stmt->close();
$connection->close();

