<?php
session_start();
include '../database/db.php'; // DB connection

// Fetch appointments with status Approved or Rejected
$sql = "SELECT appointment_id, first_name, last_name, appointment_date, reference_id, status 
        FROM appointments 
        WHERE status IN ('Approved', 'Rejected')
        ORDER BY appointment_date DESC";

$result = $connection->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    <link rel="icon" type="image/x-icon" href="../image/icons/logo1.ico">
    <link rel="stylesheet" href="../css/style.css">
    <link rel="stylesheet" href="../css/record1.css">
    <title>Appointment Records</title>
</head>
<body>
    <div class="sidebar">
        <img src="../image/icons/logo1.ico" alt="Organization Logo" class="logo">
            <button class="close-sidebar" aria-label="Close Sidebar">
                <i class='bx bx-x'></i>
            </button>
        <h2>Admin Dashboard</h2>
        <a href="./admin_dashboard.php">Home</a>
        <a href="./record.php" class="active">Record</a>
        <a href="./notifications.php">Notifications <span id="notification-count" style="display:none;" class="badge"></span></a>
        <a href="../logout.php">Logout</a>
    </div>

    <div class="main-content">
        <div class="dashboard-header">
            <button class="menu-toggle" aria-label="Toggle Sidebar" aria-expanded="false">
                <i class='bx bx-menu'></i>
            </button>
            <h1>Accepted and Declined Appointments</h1>
        </div>
        <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Reference ID</th>
                    <th>Full Name</th>
                    <th>Appointment Date</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($result && $result->num_rows > 0): ?>
                    <?php while($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['reference_id'] ?: 'N/A') ?></td>
                            <td><?= htmlspecialchars($row['first_name'] . ' ' . $row['last_name']) ?></td>
                            <td><?= htmlspecialchars(date('F j, Y', strtotime($row['appointment_date']))) ?></td>
                            <td class="<?= strtolower($row['status']) ?>">
                                <?= htmlspecialchars($row['status']) ?>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr><td colspan="4">No approved or rejected appointments found.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
        </div>
    </div>
    <script src="../scripts/script_admin1.js"></script>
</body>
</html>
