<?php
session_start();
header('Content-Type: application/json');
include '../database/db.php';

if (!isset($_SESSION['status_Account']) || $_SESSION['status_Account'] !== 'logged_in') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$appointment_id = $_POST['appointment_id'] ?? '';
$remarks = $_POST['remarks'] ?? '';

if (!$appointment_id) {
    echo json_encode(['success' => false, 'message' => 'Invalid appointment ID']);
    exit;
}

$stmt = $connection->prepare("UPDATE appointments SET remarks = ? WHERE appointment_id = ?");
$stmt->bind_param("si", $remarks, $appointment_id);

if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Database error']);
}