<?php
session_start();

function logError($message) {
    file_put_contents('error_log.txt', date('Y-m-d H:i:s') . ": $message\n", FILE_APPEND);
}

$success_message = '';
$otp_expired_message = '';
$session_expired = false;

    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $user_otp = $_POST['otp'] ?? '';
        $email = $_SESSION['email'] ?? null;
        $session_otp = $_SESSION['otp'] ?? null;

        if (!$email || !$session_otp) {
            $session_expired = true;

    if ($email) {
        include "../database/db.php";

        $delete_sql = "DELETE FROM data 
                    WHERE email = ? 
                    AND status_Account = 'pending'
                    AND (verify_otp IS NULL OR verify_otp = '')";

        $delete_stmt = $connection->prepare($delete_sql);

        if ($delete_stmt) {
            $delete_stmt->bind_param("s", $email);
            $delete_stmt->execute();
            $delete_stmt->close();
        } else {
            logError("Delete prepare error: " . $connection->error);
        }
    }
    } else {
        $otp_time = $_SESSION['otp_time'] ?? 0;

        if ((time() - $otp_time) > 180) {
            $otp_expired_message = 'OTP has expired. Please click "Resend OTP".';

        } elseif ($user_otp === $session_otp) {

            include "../database/db.php";
            $sql = "UPDATE data SET status_Account = 'verified', otp = NULL, verify_otp = ? WHERE email = ?";
            $stmt = $connection->prepare($sql);

            if ($stmt) {
                $stmt->bind_param("ss", $user_otp, $email);

                if ($stmt->execute()) {
                    $success_message = 'Registration successful!';
                    session_destroy();
                } else {
                    logError("Execution error: " . $stmt->error);
                    $error_message = "Something went wrong.";
                }

                $stmt->close();
            } else {
                logError("Prepare error: " . $connection->error);
                $error_message = "Database error.";
            }

        } else {
            $error_message = 'Invalid OTP. Please try again.';
        }
    }
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    <link rel="icon" type="image/x-icon" href="./image/icons/logo1.ico">
    <title>OTP Verification</title>
    <link rel="stylesheet" href="../css/verify1.css">
</head>
<body>
    <div class="form-container">
        <h5>Verify OTP</h5>
        <div class="subtitle">Please check your email or spam for the OTP</div>
        <div class="timer" id="otp-timer" data-otp-time="<?php echo $_SESSION['otp_time'] ?? ''; ?>"></div>
        <?php if (!empty($success_message)): ?>
            <div class="success-message" id="success-message" style="display: block;"><?php echo $success_message; ?></div>
        <?php elseif (!empty($otp_expired_message)): ?>
            <div class="expired-message" id="expired-message" style="display: block;"><?php echo $otp_expired_message; ?></div>
        <?php endif; ?>
        <form action="" method="POST" id="verifyForm" <?php echo (!empty($success_message)) ? 'style="display: none;"' : ''; ?>>
            <div class="input-group">
                <i class='bx bxs-key icon-left'></i>
                <input type="text" name="otp" id="otp" placeholder="Enter 6-digit OTP" pattern="\d{6}" maxlength="6" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 6)" autocomplete="off" required>
            </div>
            <div class="error-message-otp" id="otp-error"><?php echo isset($_POST['otp']) && $_POST['otp'] != $_SESSION['otp'] ? 'Invalid OTP. Please try again.' : ''; ?></div>
            <button type="submit" id="submit-btn"><span class="button-content">Verify <i class='bx bx-right-arrow-alt'></i></span></button>
            <a href="../authentication/resendotp.php" class="resendotp-link" id="resend-otp">Resend OTP</a>
            <a href="../register.php" class="register-link">Back to Register</a>
        </form>
    </div>

    <?php if ($session_expired): ?>
        <div class="modal show" id="sessionExpiredModal">
            <div class="modal-content">
                <i class='bx bxs-error-circle'></i>
                <h3>Session Expired</h3>
                <p>Your session has expired. Please register again to receive a new OTP.</p>
                <button onclick="window.location.href='../registration/register.php'">Back to Register</button>
            </div>
        </div>
    <?php endif; ?>

    <script src="../scripts/verify1.js"></script>
</body>
</html>