<?php
session_start();
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

if (!isset($_SESSION['status_Account']) || $_SESSION['status_Account'] !== 'logged_in') {
    header("Location: ../../index.php");
    exit;
}

include '../../database/db.php';

$email = $_SESSION['email'];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['clear_appointments'])) {
    $stmt = $connection->prepare("DELETE FROM appointments WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->close();
    
    // Optional: Refresh page to show updated list
    header("Location: appointment_table.php");
    exit();
}

// Fetch only the logged-in user's appointments
$stmt = $connection->prepare("SELECT * FROM appointments WHERE email = ? ORDER BY created_at DESC");
$stmt->bind_param("s", $email);
$stmt->execute();
$appointments = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>My Appointments</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    <link rel="icon" href="../../image/icons/logo1.ico" type="image/x-icon">
    <link rel="stylesheet" href="../../css/style_user1.css">
    <link rel="stylesheet" href="../../css/appointment_table1.css">
</head>
<body>
    
<div class="sidebar">
    <button class="close-sidebar" aria-label="Close Sidebar">
        <i class='bx bx-x'></i>
    </button>
    <img src="../../image/icons/logo1.ico" alt="Organization Logo" class="logo">
    <h2>Dashboard</h2>

    <a href="../dashboard.php" class="<?= basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : '' ?>">Dashboard</a>
    <a href="../edit_profile/edit_profile.php" class="<?= basename($_SERVER['PHP_SELF']) == 'edit_profile.php' ? 'active' : '' ?>">Edit Profile</a>
    <a href="appointment_table.php" class="<?= basename($_SERVER['PHP_SELF']) == 'appointment_table.php' ? 'active' : '' ?>">Appointments</a>
    <a href="../../logout.php">Logout</a>
</div>


<div class="main-content">
    <div class="dashboard-header">
        <button class="menu-toggle" aria-label="Toggle Sidebar" aria-expanded="false">
            <i class='bx bx-menu'></i>
        </button>
        <h1>My Appointments</h1>
        <a href="../../fillupform/fillupform.php" class="action-btn">Book Appointment</a>
    </div>


    <?php if ($appointments->num_rows > 0): ?>
        <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Date</th> 
                    <th>Time</th>
                    <th>Purpose</th>
                    <th>Status</th>
                    <th>Submitted</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $appointments->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars(date("F j, Y", strtotime($row['appointment_date']))) ?></td>
                        <td><?= htmlspecialchars(date("g:i A", strtotime($row['appointment_time']))) ?></td>
                        <td><?= htmlspecialchars($row['purpose']) ?></td>
                        <td><span class="status <?= $row['status'] ?>"><?= htmlspecialchars($row['status']) ?></span></td>
                        <td><?= htmlspecialchars(date("F j, Y g:i A", strtotime($row['created_at']))) ?></td>
                        <td>
                                                        <!-- view btn -->
                            <form method="GET" action="../dashboard.php" style="display:inline;">
                                <input type="hidden" name="appointment_id" value="<?= $row['appointment_id'] ?>">
                                <button type="submit" class="action-btn" style="background: #007bff; margin-top: 5px;">View</button>
                            </form>
                            <form method="POST" action="cancel_appointment.php" style="display:inline;" onsubmit="return confirm('Are you sure you want to cancel this appointment?');">
                                <input type="hidden" name="appointment_id" value="<?= $row['appointment_id'] ?>">
                                <?php if ($row['status'] === 'Pending'): ?>
                                    <button type="submit" class="action-btn" style="background: #dc3545;">Cancel</button>
                                <?php else: ?>
                                    <button type="button" class="action-btn" style="background: grey;" disabled>Cancel</button>
                                <?php endif; ?>
                            </form>
                        </td>

                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
        </div>
  		<p style="margin-top: 10px; color: #555; font-size: 13px;">
            <em>Note:</em> You can only cancel appointments that are still <strong>Pending</strong>. 
            Once an appointment is <strong>Accepted</strong> or <strong>Rejected</strong>, it becomes a permanent record that serves as proof of your evaluation. 
            If you wish to remove all appointments, you may click <strong>Clear All Appointments</strong>.
        </p>
            <form method="POST" onsubmit="return confirm('Are you sure you want to delete all your appointments? This cannot be undone.');">
                <button type="submit" name="clear_appointments" class="action-btn" style="background: #dc3545; margin-top: 20px;">Clear All Appointments</button>
            </form>
    <?php else: ?>
        <p>No appointments found.</p>
    <?php endif; ?>
</div>

</body>

<script src="../../scripts/script_user1.js"></script>

</html>
