<?php
session_start();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    <link rel="icon" type="image/x-icon" href="../image/icons/logo1.ico">
    <link rel="stylesheet" href="../../css/register1.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <title>Registration</title>
</head>
<body>
    <div class="form-container max-w-md w-full bg-white/50 backdrop-blur-md rounded-2xl shadow-2xl p-8 sm:p-10 transition-all duration-300">
        <h5 class="text-2xl sm:text-3xl font-bold text-gray-900 text-center mb-4">Create Account</h5>
        <div class="subtitle text-sm sm:text-base text-gray-600 text-center mb-6">Sign up to get started</div>
        <div id="form-message" class="form-message hidden text-sm sm:text-base text-center px-4 py-3 rounded-lg mb-6"></div>
        <form action="../authentication/send.php" method="POST" id="registerForm" class="space-y-4">
            <div class="input-group relative">
                <i class='bx bxs-user absolute top-1/2 left-3 transform -translate-y-1/2 text-gray-500 text-lg sm:text-xl'></i>
                <input 
                    type="email" 
                    name="email" 
                    id="email" 
                    placeholder="Enter your email" 
                    autocomplete="off" 
                    required 
                    class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg bg-white/50 text-sm sm:text-base focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200"
                >
                <i class='bx bxs-check-circle absolute top-1/2 right-3 transform -translate-y-1/2 text-green-500 text-lg sm:text-xl hidden' id="email-valid"></i>
            </div>
            <div class="error-message text-red-600 text-xs sm:text-sm ml-2" id="email-error"></div>

            <div class="input-group relative">
                <i class='bx bxs-lock-alt absolute top-1/2 left-3 transform -translate-y-1/2 text-gray-500 text-lg sm:text-xl'></i>
                <i class='bx bx-show absolute top-1/2 right-3 transform -translate-y-1/2 text-gray-500 text-lg sm:text-xl cursor-pointer toggle-password' data-target="password"></i>
                <input 
                    type="password" 
                    name="password" 
                    id="password" 
                    placeholder="Create a password" 
                    autocomplete="off" 
                    required 
                    class="w-full pl-10 pr-12 py-3 border border-gray-300 rounded-lg bg-white/50 text-sm sm:text-base focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200"
                >
                <i class='bx bxs-check-circle absolute top-1/2 right-9 transform -translate-y-1/2 text-green-500 text-lg sm:text-xl hidden' id="password-valid"></i>
            </div>
            <div class="error-message text-red-600 text-xs sm:text-sm ml-2" id="password-error"></div>
            <div class="password-strength text-xs sm:text-sm ml-2" id="password-strength"></div>

            <div class="input-group relative">
                <i class='bx bxs-lock-alt absolute top-1/2 left-3 transform -translate-y-1/2 text-gray-500 text-lg sm:text-xl'></i>
                <i class='bx bx-show absolute top-1/2 right-3 transform -translate-y-1/2 text-gray-500 text-lg sm:text-xl cursor-pointer toggle-password' data-target="cpassword"></i>
                <input 
                    type="password" 
                    name="cpassword" 
                    id="cpassword" 
                    placeholder="Confirm your password" 
                    autocomplete="off" 
                    required 
                    class="w-full pl-10 pr-12 py-3 border border-gray-300 rounded-lg bg-white/50 text-sm sm:text-base focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200"
                >
                <i class='bx bxs-check-circle absolute top-1/2 right-9 transform -translate-y-1/2 text-green-500 text-lg sm:text-xl hidden' id="cpassword-valid"></i>
            </div>
            <div class="error-message text-red-600 text-xs sm:text-sm ml-2" id="cpassword-error"></div>

            <input type="hidden" name="otp" id="otp">
            <input type="hidden" name="subject" value="OTP Verification Code">
            <button 
                type="submit" 
                id="submit-btn" 
                disabled 
                class="w-full flex items-center justify-center px-4 py-3 bg-gradient-to-r from-blue-600 to-blue-800 text-white font-medium rounded-lg text-sm sm:text-base hover:from-blue-700 hover:to-blue-900 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition-all duration-200 disabled:bg-gray-400 disabled:cursor-not-allowed"
            >
                <span class="button-content flex items-center gap-2">
                    Register <i class='bx bx-right-arrow-alt'></i>
                </span>
            </button>
            <a href="./index.php" class="login-link text-blue-600 hover:underline transition-colors duration-200 text-sm sm:text-base block text-center mt-4">Already have an account? Login</a>
        </form>
    </div>

<script src="../scripts/register1.js"></script>
</body>
</html>