document.addEventListener('DOMContentLoaded', function() {
        const sidebar = document.querySelector('.sidebar');
        const menuToggle = document.querySelector('.menu-toggle');
        const closeSidebar = document.querySelector('.close-sidebar');
        const mainContent = document.querySelector('.main-content');
        const isMobile = window.matchMedia('(max-width: 576px)').matches;

        function toggleSidebar() {
            const isActive = sidebar.classList.toggle('active');
            mainContent.classList.toggle('sidebar-active', isActive);
            menuToggle.setAttribute('aria-expanded', isActive);
        }

        function closeSidebarOnMobile() {
            if (window.matchMedia('(max-width: 576px)').matches) {
                sidebar.classList.remove('active');
                mainContent.classList.remove('sidebar-active');
                menuToggle.setAttribute('aria-expanded', 'false');
            }
        }

        menuToggle.addEventListener('click', toggleSidebar);
        closeSidebar.addEventListener('click', closeSidebarOnMobile);

        document.querySelectorAll('.sidebar a').forEach(link => {
            link.addEventListener('click', closeSidebarOnMobile);
        });

        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape' && isMobile && sidebar.classList.contains('active')) {
                closeSidebarOnMobile();
            }
        });

        window.addEventListener('pageshow', function(event) {
            if (event.persisted || (window.performance && window.performance.navigation.type === 2)) {
                window.location.reload();
            }
        });

        if (isMobile) {
            closeSidebarOnMobile();
        }

        
        updateNotificationCount();
    });

    function updateNotificationCount() {
        fetch('./notification_fetch.php')
            .then(res => res.json())
            .then(data => {
                const countSpan = document.getElementById('notification-count');
                if (data.length > 0) {
                    countSpan.style.display = 'inline-block';
                    countSpan.textContent = data.length;
                } else {
                    countSpan.style.display = 'none';
                }
            });
    }